@extends('layouts.app')

@section('title', 'Admin - ' . $ticket->subject)

@section('content')
<div class="admin-ticket-show">
    <div class="container">
        <div class="ticket-header-section">
            <h1>{{ $ticket->subject }}</h1>
            <div class="ticket-meta-info">
                <span class="badge badge-{{ $ticket->status }}">{{ ucfirst($ticket->status) }}</span>
                <span class="badge badge-priority-{{ $ticket->priority }}">{{ ucfirst($ticket->priority) }} Priority</span>
                <span>By: {{ $ticket->user->name }} ({{ $ticket->user->email }})</span>
                <span>Created: {{ $ticket->created_at->format('M d, Y H:i') }}</span>
            </div>
        </div>

        <div class="ticket-main">
            <div class="ticket-description">
                <h3>Description</h3>
                <p>{{ $ticket->description }}</p>
                
                @if($ticket->attachments->where('ticket_reply_id', null)->count() > 0)
                    <div class="attachments">
                        <h4>Attachments</h4>
                        <ul>
                            @foreach($ticket->attachments->where('ticket_reply_id', null) as $attachment)
                                <li>
                                    <a href="{{ asset('storage/' . $attachment->file_path) }}" target="_blank">
                                        {{ $attachment->file_name }}
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                @endif
            </div>

            <div class="ticket-replies">
                <h3>Replies ({{ $ticket->replies->count() }})</h3>
                
                @foreach($ticket->replies as $reply)
                    <div class="reply-card">
                        <div class="reply-header">
                            <strong>{{ $reply->user->name }}</strong>
                            <span>{{ $reply->created_at->format('M d, Y H:i') }}</span>
                        </div>
                        <div class="reply-message">
                            {{ $reply->message }}
                        </div>
                        @if($reply->attachments->count() > 0)
                            <div class="attachments">
                                <h4>Attachments</h4>
                                <ul>
                                    @foreach($reply->attachments as $attachment)
                                        <li>
                                            <a href="{{ asset('storage/' . $attachment->file_path) }}" target="_blank">
                                                {{ $attachment->file_name }}
                                            </a>
                                        </li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                    </div>
                @endforeach
            </div>

            <div class="reply-form-section">
                <h3>Reply to Ticket</h3>
                <form method="POST" action="{{ route('admin.tickets.reply', $ticket) }}" enctype="multipart/form-data">
                    @csrf
                    
                    <div class="form-group">
                        <label for="status">Status</label>
                        <select id="status" name="status" required>
                            <option value="open" {{ $ticket->status == 'open' ? 'selected' : '' }}>Open</option>
                            <option value="in_progress" {{ $ticket->status == 'in_progress' ? 'selected' : '' }}>In Progress</option>
                            <option value="closed" {{ $ticket->status == 'closed' ? 'selected' : '' }}>Closed</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="message">Message</label>
                        <textarea id="message" name="message" rows="6" required></textarea>
                    </div>

                    <div class="form-group">
                        <label for="attachments">Attachments</label>
                        <input type="file" id="attachments" name="attachments[]" multiple>
                        <small>You can upload multiple files (Max 10MB per file)</small>
                    </div>

                    <button type="submit" class="btn btn-primary">Send Reply</button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

